* Introduction to Unity IAP
    * [About Unity IAP](index.md)
    * [Stores supported by Unity IAP](StoresSupported.md)
* Set up and integrating Unity IAP
    * [Overview](Overview.md)
    * [Getting Started](GettingStarted.md)
    * Defining products
        * [Overview](DefiningProductsOverview.md)
        * [Coded](DefiningProductsCoded.md)
        * [IAP Catalog](UnityIAPDefiningProducts.md)
    * [Initialize IAP](UnityIAPInitialization.md)
    * [Fetching Additional Products](UnityIAPFetchingProductsIncrementally.md)
    * Creating a Purchasing Button
        * [Browsing Product Metadata](UnityIAPBrowsingMetadata.md)
        * [IAP Button](IAPButton.md)
        * [Coded](UnityIAPInitiatingPurchases.md)
    * The Purchasing Flow
        * Processing Purchases
            * [Coded](UnityIAPProcessingPurchases.md)
            * [IAP Listener](IAPListener.md)
            * [Handling Purchase Failures](UnityIAPHandlingPurchaseFailures.md)
        * [Purchase Receipts](UnityIAPPurchaseReceipts.md)
        * [Restoring Transactions](UnityIAPRestoringTransactions.md)
    * Securing Transactions
        * [Backend Receipt Validation](BackendReceiptValidation.md)
        * [Receipt Obfuscation](UnityIAPValidatingReceipts.md)
    * [Store Selector](StoreSelector.md)
    * Testing the Integration
        * [What is Fake Store?](WhatIsFakeStore.md)
        * [How to Test](HowToTest.md)
* Stores
    * Google
        * [How to Set Up](UnityIAPGoogleConfiguration.md)
        * [Setting Google Public Key](GooglePublicKey.md)
        * [Extensions and Configuration](UnityIAPGooglePlay.md)
        * [Purchase Receipt](GoogleReceipt.md)
        * [Testing Integration](Testing.md)
    * Amazon
        * [How to Set Up](UnityIAPAmazonConfiguration.md)
        * [Extensions](UnityIAPAmazonExtendedFunctionality.md)
        * [Testing Integration](AmazonTesting.md)
    * Apple Store iOS, MacOS & tvOS
        * [How to Set Up](UnityIAPAppleConfiguration.md)
        * [Extensions and Configuration](UnityIAPiOSMAS.md)
        * [Purchase Receipt](AppleReceipt.md)
        * [Testing](AppleTesting.md)
    * Microsoft Store (UWP)
        * [How to Set Up](UnityIAPWindowsConfiguration.md)
        * [Purchase Receipt](MicrosoftReceipt.md)
        * [Testing](UnityIAPUniversalWindows.md)
    * Implement Custom Store
        * [What is a Custom Store](WhatCustomStore.md)
        * [Implementing](UnityIAPImplementingAStore.md)
        * [Initialization](UnityIAPIStoreInitialization.md)
        * [Retrieving products](UnityIAPIStoreRetrievingProducts.md)
        * [Handling purchases](UnityIAPIStoreHandlingPurchases.md)
        * [Store Modules](UnityIAPModules.md)
            * [Registering your store](UnityIAPModuleRegistration.md)
            * [Store Configuration](UnityIAPModuleConfiguration.md)
            * [Store Extensions](UnityIAPModuleExtension.md)
